/*
 * Decompiled with CFR 0.152.
 */
package net.spellcraftgaming.rpghud.gui.hud.element.vanilla;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.minecraft.client.gui.GuiGraphics;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElement;
import net.spellcraftgaming.rpghud.gui.hud.element.HudElementType;

public class HudElementMiscVanilla
extends HudElement {
    public HudElementMiscVanilla() {
        super(HudElementType.MISC, 0, 0, 0, 0, true);
    }

    @Override
    public boolean checkConditions() {
        return !this.mc.f_91066_.f_92063_;
    }

    @Override
    public void drawElement(GuiGraphics gg, float zLevel, float partialTicks, int scaledWidth, int scaledHeight) {
        if (this.settings.getBoolValue("enable_fps").booleanValue()) {
            this.renderFPS(gg, scaledWidth, scaledHeight);
        }
        if (this.settings.getBoolValue("enable_system_time").booleanValue()) {
            this.renderSystemTime(gg, scaledWidth, scaledHeight);
        }
    }

    private void renderFPS(GuiGraphics gg, int scaledWidth, int scaledHeight) {
        float scale = (float)this.settings.getDoubleValue("fps_scale");
        gg.m_280168_().m_85841_(scale, scale, scale);
        scale = this.getInvertedScale(scale);
        String fps = this.mc.f_90977_.split(" ")[0];
        int posX = (int)((float)(1 + this.settings.getPositionValue("fps_position")[0]) * scale);
        int posY = (int)((float)(1 + this.settings.getPositionValue("fps_position")[0]) * scale);
        gg.m_280488_(this.mc.f_91062_, fps, posX, posY, this.settings.getIntValue("color_fps").intValue());
        gg.m_280168_().m_85841_(scale, scale, scale);
    }

    private void renderSystemTime(GuiGraphics gg, int scaledWidth, int scaledHeight) {
        float scale = (float)this.settings.getDoubleValue("system_time_scale");
        gg.m_280168_().m_85841_(scale, scale, scale);
        scale = this.getInvertedScale(scale);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm");
        String time = formatter.format(LocalDateTime.now());
        int posX = Math.round((float)(1 + this.settings.getPositionValue("system_time_position")[0]) * scale);
        int posY = Math.round((float)(scaledHeight - 1 + this.settings.getPositionValue("system_time_position")[0]) * scale) - 8;
        if (this.settings.getBoolValue("enable_system_time_background").booleanValue()) {
            int width = Math.round(2.0f * scale + (float)this.mc.f_91062_.m_92895_(String.valueOf(time)));
            HudElementMiscVanilla.drawRect(gg, Math.round((float)posX - 1.0f * scale), Math.round((float)posY - 1.0f * scale) - 1, width, Math.round(10.0f + 1.0f * scale), -1610612736);
        }
        gg.m_280488_(this.mc.f_91062_, time, posX, posY, this.settings.getIntValue("color_system_time").intValue());
        gg.m_280168_().m_85841_(scale, scale, scale);
    }

    public float getInvertedScale(float scale) {
        return 1.0f / scale;
    }
}

